from aiohttp.web import Request, Response

from maps_adv.points.server.lib.api.providers import PointsApiProvider
from maps_adv.points.server.lib.data_managers import PointsDataManager

__all__ = ["PointsResources"]


class PointsResources:
    __slots__ = ("_provider",)

    _provider: PointsApiProvider

    def __init__(self, dm: PointsDataManager):
        self._provider = PointsApiProvider(dm)

    async def find_within_polygons(self, request: Request) -> Response:
        point_type = request.match_info["type"]
        version = request.match_info["version"]
        body = await request.read()

        result = await self._provider.find_within_polygons(
            body, point_type=point_type, version=version
        )

        return Response(body=result, status=200)
