from operator import attrgetter

from asyncpg.connection import Connection

from smb.common.pgswim import SwimEngine
from maps_adv.points.server.lib.enums import PointType

__all__ = ["DB"]


class DB(SwimEngine):
    @staticmethod
    async def _set_codecs(con: Connection) -> Connection:
        await con.set_type_codec(
            "point_type", encoder=attrgetter("name"), decoder=PointType
        )
