"""empty message

Revision ID: 0f8b5ed13eba
Revises:
Create Date: 2019-12-12 11:37:33.427558

"""
import sqlalchemy as sa
from alembic import op
from geoalchemy2 import Geometry

from maps_adv.points.server.lib.db.migrations.extra_op import ReplacableObject

revision = "0f8b5ed13eba"
down_revision = None
branch_labels = None
depends_on = None


points_view = ReplacableObject(
    "points_view",
    """
SELECT
    id,
    ST_ShiftLongitude(geometry) AS geometry,
    collection_id,
    ST_X(geometry)::text AS longitude,
    ST_Y(geometry)::text AS latitude
FROM points""",
)


def upgrade():
    op.create_table(
        "collections",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "type", sa.Enum("billboard", "testing", name="point_type"), nullable=False
        ),
        sa.Column("version", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_collections")),
        sa.UniqueConstraint(
            "type", "version", name=op.f("uq_collections_type_version")
        ),
    )

    op.create_table(
        "shows_forecasts",
        sa.Column("geohash", sa.String(length=6), nullable=False),
        sa.Column("pin_shows", sa.Integer(), nullable=False),
        sa.Column("billboard_shows", sa.Integer(), nullable=False),
        sa.Column("zsb_shows", sa.Integer(), nullable=False),
        sa.CheckConstraint(
            "length(geohash) = 6", name=op.f("ck_shows_forecasts_geohash_length")
        ),
        sa.PrimaryKeyConstraint("geohash", name=op.f("pk_shows_forecasts")),
    )
    op.create_index(
        "shows_forecasts_geohash_as_shifted_point",
        "shows_forecasts",
        [
            sa.text(
                'ST_ShiftLongitude(ST_SetSRID(ST_PointFromGeoHash("geohash"), 4326))'
            )
        ],
        unique=False,
        postgresql_using="gist",
    )
    op.create_index(
        "shows_forecasts_geohash_hash",
        "shows_forecasts",
        ["geohash"],
        unique=False,
        postgresql_using="hash",
    )

    op.create_table(
        "points",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "geometry",
            Geometry(geometry_type="POINT", srid=4326, spatial_index=False),
            nullable=False,
        ),
        sa.Column("collection_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["collection_id"],
            ["collections.id"],
            name=op.f("fk_points_collection_id_collections"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_points")),
        sa.UniqueConstraint(
            "geometry", "collection_id", name=op.f("uq_points_geometry_collection_id")
        ),
    )
    op.create_index(
        "points_geometry_gist_index",
        "points",
        ["geometry"],
        unique=False,
        postgresql_using="gist",
    )

    op.create_materialized_view(points_view)
    op.create_index(
        "points_view_geometry_gist_index",
        "points_view",
        ["geometry"],
        unique=False,
        postgresql_using="gist",
    )
    op.create_index(
        "points_view_collection_id_hash_index",
        "points_view",
        ["collection_id"],
        unique=False,
        postgresql_using="hash",
    )


def downgrade():
    op.drop_index("points_view_collection_id_hash_index", table_name="points_view")
    op.drop_index("points_view_geometry_gist_index", table_name="points_view")
    op.drop_materialized_view(points_view)

    op.drop_index("points_geometry_gist_index", table_name="points")
    op.drop_table("points")

    op.drop_index(
        "shows_forecasts_geohash_as_shifted_point", table_name="shows_forecasts"
    )
    op.drop_index("shows_forecasts_geohash_hash", table_name="shows_forecasts")
    op.drop_table("shows_forecasts")

    op.execute("DROP TYPE point_type CASCADE")
    op.drop_table("collections")
