import sqlalchemy as sa
from geoalchemy2 import Geometry

from .tables import metadata

__all__ = ["points"]

points = sa.Table(
    "points_view",
    metadata,
    sa.Column("id", sa.Integer),
    sa.Column("geometry", Geometry(geometry_type="POINT", srid=4326)),
    sa.Column("collection_id", sa.Integer),
    sa.Column("longitude", sa.Integer),
    sa.Column("latitude", sa.Text),
    sa.Index("points_view_geometry_gist_index", "geometry", postgresql_using="gist"),
    sa.Index(
        "points_view_collection_id_hash_index", "collection_id", postgresql_using="hash"
    ),
)
