PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock

    maps_adv/common/pgswim

    maps_adv/points/server
)

SRCDIR(maps_adv/points/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/forecasts/__init__.py
    api/points/__init__.py
    conftest.py
    data_managers/__init__.py
    data_managers/forecasts/__init__.py
    data_managers/points/__init__.py
    dms.py
    factory.py
    generators.py
    tasks/__init__.py
)

TEST_SRCS(
    api/forecasts/test_forecasts_billboard.py
    api/forecasts/test_forecasts_pins.py
    api/forecasts/test_forecasts_zerospeed.py
    api/points/test_find_within_polygons.py
    api/test_ping.py
    data_managers/forecasts/test_forecast_billboard.py
    data_managers/forecasts/test_forecast_pins.py
    data_managers/forecasts/test_forecast_zerospeed.py
    data_managers/forecasts/test_sync_forecasts.py
    data_managers/points/test_find_within_polygons.py
    tasks/test_sync_forecasts.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://points:points@localhost:5433/points)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)


END()

