PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/alembic
    contrib/python/sqlalchemy/sqlalchemy-1.2  # transition; see https://st.yandex-team.ru/CONTRIB-2042
    contrib/python/asyncpg
    contrib/python/GeoAlchemy2
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2
    contrib/python/psycopg2
    yt/python/client

    yql/library/python

    smb/common/multiruntime
    smb/common/pgswim

    maps_adv/points/proto
    maps_adv/common/pg_engine
    maps_adv/common/protomallow
    maps_adv/warden/client
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers/__init__.py
    lib/api/providers/base.py
    lib/api/providers/forecasts.py
    lib/api/providers/points.py
    lib/api/resources/__init__.py
    lib/api/resources/forecasts.py
    lib/api/resources/ping.py
    lib/api/resources/points.py
    lib/data_managers/__init__.py
    lib/data_managers/forecasts.py
    lib/data_managers/points.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/db/migrations/extra_op.py
    lib/db/tables.py
    lib/db/views.py
    lib/enums.py
    lib/exceptions.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/points/server/
    alembic.ini
    lib/db/migrations/env.py
    lib/db/migrations/script.py.mako
    lib/db/migrations/versions/20191212_1137_0f8b5ed13eba.py
    lib/db/migrations/versions/20200730_1631_de9edced7332.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(app)
