__all__ = [
    "StatControllerClientException",
    "NoTasksFound",
    "UnknownResponse",
    "InternalServerError",
    "BadGateway",
    "GatewayTimeout",
    "WrongPayload",
    "Conflict",
    "InvalidContentType",
]


class StatControllerClientException(Exception):
    pass


class NoTasksFound(StatControllerClientException):
    pass


class InternalServerError(StatControllerClientException):
    pass


class BadGateway(StatControllerClientException):
    pass


class GatewayTimeout(StatControllerClientException):
    pass


class WrongPayload(StatControllerClientException):
    pass


class Conflict(StatControllerClientException):
    pass


class InvalidContentType(StatControllerClientException):
    pass


class UnknownResponse(StatControllerClientException):
    def __init__(self, status_code: int, payload: bytes):
        super().__init__(f"Status={status_code}, payload={payload}")

        self.status_code = status_code
        self.payload = payload
