import logging

import sentry_sdk
from sentry_sdk.integrations.aiohttp import AioHttpIntegration

from maps_adv.config_loader import Config
from maps_adv.stat_controller.server.lib import Application

_config = {
    "DATABASE_URL": {},
    "DATABASE_URL_RO": {"default": None},
    "MIN_TIME_RANGE": {"default": 300, "converter": int},
    "MAX_TIME_RANGE": {"default": 600, "converter": int},
    "MAX_TIME_RANGE_TO_SKIP": {"default": 60, "converter": int},
    "TIME_LAG": {"default": 10, "converter": int},
    # used to mark expired task as failed
    "TASK_LIFETIME": {"default": 300, "converter": int},
    "TIME_PERIOD_AUTO_MARK_EXPIRED_TASKS": {"default": 60, "converter": int},
    "SENTRY_DSN": {"default": None},
}

config = Config(_config)


def main():
    logging.basicConfig(level=logging.DEBUG)
    config.init()

    sentry_dsn = config["SENTRY_DSN"]
    if sentry_dsn:
        sentry_sdk.init(sentry_dsn, integrations=[AioHttpIntegration()])

    app = Application(config)
    app.run()


if __name__ == "__main__":
    main()
