from aiohttp import web

from maps_adv.stat_controller.server.lib import api_providers
from maps_adv.stat_controller.server.lib.data_managers import SystemOp

from . import charger, collector, middlewares, normalizer, system_op

__all__ = ["create"]


def create(
    normalizer_api_provider: api_providers.Normalizer,
    charger_api_provider: api_providers.Charger,
    collector_api_provider: api_providers.Collector,
    system_op_dm: SystemOp,
) -> web.Application:
    normalizer_resources = normalizer.Resources(normalizer_api_provider)
    charger_resources = charger.Resources(charger_api_provider)
    collector_resources = collector.Resources(collector_api_provider)
    system_op_resources = system_op.Resources(system_op_dm)

    api = web.Application(
        middlewares=[
            middlewares.handle_unexpected_content_type,
            middlewares.handle_json_decode_error,
            middlewares.handle_validation_error,
            middlewares.handle_status_sequence_violation_error,
            middlewares.handlein_progress_by_another_executor_error,
            middlewares.handle_conflict_operation,
        ]
    )
    api.add_routes(
        [
            web.get("/ping", system_op_resources.ping),
            web.post("/tasks/normalizer/", normalizer_resources.find_new),
            web.put("/tasks/normalizer/{task_id}/", normalizer_resources.update),
            web.post("/tasks/charger/", charger_resources.find_new),
            web.put("/tasks/charger/{task_id}/", charger_resources.update),
            web.post("/tasks/collector/", collector_resources.find_new),
            web.put("/tasks/collector/{task_id}/", collector_resources.update),
        ]
    )
    return api
