from aiohttp.web import Request, Response, json_response

from maps_adv.stat_controller.server.lib.api_providers.collector import ApiProvider

__all__ = ["Resources"]


class Resources:
    __slots__ = ("_provider",)

    _provider: ApiProvider

    def __init__(self, provider: ApiProvider):
        self._provider = provider

    async def find_new(self, request: Request) -> Response:
        data = await request.json()

        got = await self._provider.find_new(**data)
        return json_response(data=got, status=201 if got else 200)

    async def update(self, request: Request) -> Response:
        data = await request.json()
        data.update(task_id=request.match_info.get("task_id"))

        got = await self._provider.update(**data)
        return json_response(data=got, status=200)
