from aiohttp.web import Request, Response, json_response

from maps_adv.stat_controller.server.lib.data_managers.system_op import SystemOpManager

__all__ = ["Resources"]


class Resources:
    __slots__ = "_dm"

    _dm: SystemOpManager

    def __init__(self, dm: SystemOpManager):
        self._dm = dm

    async def ping(self, request: Request) -> Response:
        await self._dm.validate_db_connection()
        return json_response(status=200)
