from marshmallow_enum import EnumField

from maps_adv.stat_controller.server.lib.domains.collector import Domain, TaskStatus

from .schemas import (
    FindNewTaskSchema,
    TaskDetailsSchema,
    UpdateTaskSchema as BaseUpdateTaskSchema,
    with_schemas,
)

__all__ = ["ApiProvider"]


class UpdateTaskSchema(BaseUpdateTaskSchema):
    status = EnumField(TaskStatus, required=True)


class ApiProvider:
    __slots__ = ("_domain",)

    _domain: Domain

    def __init__(self, domain: Domain):
        self._domain = domain

    @with_schemas(FindNewTaskSchema, TaskDetailsSchema)
    async def find_new(self, **kwargs) -> dict:
        return await self._domain.find_new(**kwargs) or {}

    @with_schemas(UpdateTaskSchema, TaskDetailsSchema)
    async def update(self, **kwargs) -> dict:
        return await self._domain.update(**kwargs)
