import enum
from typing import Tuple

__all__ = ["TaskStatus"]


class TaskStatus(enum.Enum):
    # normalizer task
    accepted_by_normalizer = "accepted_by_normalizer"
    normalized = "normalized"

    # charger task
    accepted_by_charger = "accepted_by_charger"
    charger_received_context = "charger_received_context"
    charger_completed_calculation = "charger_completed_calculation"
    charger_notified_billing = "charger_notified_billing"
    charger_sent_charged_data = "charger_sent_charged_data"
    charged = "charged"

    accepted_by_collector = "accepted_by_collector"
    collected = "collected"

    @classmethod
    def in_progress(cls, values: bool = False) -> Tuple["TaskStatus"]:
        choices = (
            cls.accepted_by_normalizer,
            cls.accepted_by_collector,
        ) + cls.charger_in_progress()
        if values:
            choices = tuple(c.value for c in choices)
        return choices

    @classmethod
    def charger_in_progress(cls, values: bool = False) -> Tuple["TaskStatus"]:
        choices = (
            cls.accepted_by_charger,
            cls.charger_received_context,
            cls.charger_completed_calculation,
            cls.charger_notified_billing,
            cls.charger_sent_charged_data,
        )
        if values:
            choices = tuple(c.value for c in choices)
        return choices
