"""empty message

Revision ID: 658cbe218c08
Revises: 00d1282a6f9b
Create Date: 2019-09-27 08:11:10.390122

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "658cbe218c08"
down_revision = "00d1282a6f9b"
branch_labels = None
depends_on = None


old_options = (
    "accepted_by_normalizer",
    "normalized",
    "accepted_by_charger",
    "charger_received_context",
    "charger_completed_calculation",
    "charger_notified_billing",
    "charger_sent_charged_data",
    "charged",
)

new_options = old_options + ("accepted_by_collector", "collected")

old_type = sa.Enum(*old_options, name="taskstatus")
new_type = sa.Enum(*new_options, name="taskstatus")
tmp_type = sa.Enum(*new_options, name="_taskstatus")


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    tmp_type.create(op.get_bind(), checkfirst=False)
    op.execute(
        "ALTER TABLE tasks_log ALTER COLUMN status TYPE _taskstatus "
        "USING status::text::_taskstatus"
    )
    op.execute(
        "ALTER TABLE tasks ALTER COLUMN status TYPE _taskstatus "
        "USING status::text::_taskstatus"
    )
    old_type.drop(op.get_bind(), checkfirst=False)

    new_type.create(op.get_bind(), checkfirst=False)
    op.execute(
        "ALTER TABLE tasks ALTER COLUMN status TYPE taskstatus "
        "USING status::text::taskstatus"
    )
    op.execute(
        "ALTER TABLE tasks_log ALTER COLUMN status TYPE taskstatus "
        "USING status::text::taskstatus"
    )
    tmp_type.drop(op.get_bind(), checkfirst=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        "UPDATE tasks SET current_log_id = NULL "
        "WHERE status IN ('accepted_by_collector', 'collected')"
    )
    op.execute(
        "DELETE FROM tasks_log WHERE status IN ('accepted_by_collector', 'collected')"
    )
    op.execute(
        "UPDATE tasks SET status = 'charged' "
        "WHERE status IN ('accepted_by_collector', 'collected')"
    )

    tmp_type.create(op.get_bind(), checkfirst=False)
    op.execute(
        "ALTER TABLE tasks ALTER COLUMN status TYPE _taskstatus "
        "USING status::text::_taskstatus"
    )
    op.execute(
        "ALTER TABLE tasks_log ALTER COLUMN status TYPE _taskstatus "
        "USING status::text::_taskstatus"
    )
    new_type.drop(op.get_bind(), checkfirst=False)

    old_type.create(op.get_bind(), checkfirst=False)
    op.execute(
        "ALTER TABLE tasks ALTER COLUMN status TYPE taskstatus "
        "USING status::text::taskstatus"
    )
    op.execute(
        "ALTER TABLE tasks_log ALTER COLUMN status TYPE taskstatus "
        "USING status::text::taskstatus"
    )
    tmp_type.drop(op.get_bind(), checkfirst=False)
    # ### end Alembic commands ###
