"""empty message

Revision ID: 338e7eeadb1c
Revises: 658cbe218c08
Create Date: 2019-09-27 14:36:07.376900

"""
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "338e7eeadb1c"
down_revision = "658cbe218c08"
branch_labels = None
depends_on = None


def upgrade():
    op.create_index(
        "tasks_status_failed_btree_index",
        "tasks",
        ["status"],
        unique=False,
        postgresql_using="btree",
        postgresql_where=sa.text("status IS NULL"),
    )
    op.create_index(
        "tasks_status_in_progress_btree_index",
        "tasks",
        ["status"],
        unique=False,
        postgresql_using="btree",
        postgresql_where=sa.text(
            "status IN ("
            "   'accepted_by_normalizer', "
            "   'accepted_by_charger', "
            "   'charger_received_context', "
            "   'charger_completed_calculation', "
            "   'charger_notified_billing', "
            "   'charger_sent_charged_data', "
            "   'accepted_by_collector'"
            ")"
        ),
    )
    op.create_index(
        "tasks_log_status_charger_in_progress_btree_index",
        "tasks_log",
        ["status"],
        unique=False,
        postgresql_using="btree",
        postgresql_where=sa.text(
            "status IN ("
            "   'accepted_by_charger', "
            "   'charger_received_context', "
            "   'charger_completed_calculation', "
            "   'charger_notified_billing', "
            "   'charger_sent_charged_data'"
            ")"
        ),
    )
    op.create_index(
        "tasks_log_status_normalizer_in_progress_btree_index",
        "tasks_log",
        ["status"],
        unique=False,
        postgresql_using="btree",
        postgresql_where=sa.text("status = 'accepted_by_normalizer'"),
    )
    op.create_index(
        "tasks_log_status_collector_in_progress_btree_index",
        "tasks_log",
        ["status"],
        unique=False,
        postgresql_using="btree",
        postgresql_where=sa.text("status = 'accepted_by_collector'"),
    )


def downgrade():
    op.drop_index(
        "tasks_log_status_collector_in_progress_btree_index", table_name="tasks_log"
    )
    op.drop_index(
        "tasks_log_status_normalizer_in_progress_btree_index", table_name="tasks_log"
    )
    op.drop_index(
        "tasks_log_status_charger_in_progress_btree_index", table_name="tasks_log"
    )
    op.drop_index("tasks_status_in_progress_btree_index", table_name="tasks")
    op.drop_index("tasks_status_failed_btree_index", table_name="tasks")
