__all__ = [
    "StatControllerDomainException",
    "StatusSequenceViolation",
    "InProgressByAnotherExecutor",
]


class StatControllerDomainException(Exception):
    pass


class StatusSequenceViolation(StatControllerDomainException):
    def __init__(self, task_id, executor_id, current_status, target_status):
        self.task_id = task_id
        self.executor_id = executor_id
        self.current_status = current_status
        self.target_status = target_status
        StatControllerDomainException.__init__(
            self,
            f"task_id = {self.task_id}, executor_id = {self.executor_id}, "
            f"status = {self.current_status.value} -> "
            f"{self.target_status.value}",
        )


class InProgressByAnotherExecutor(StatControllerDomainException):
    def __init__(self, task_id, status, current_executor_id, executor_id):
        self.task_id = task_id
        self.status = status
        self.current_executor_id = current_executor_id
        self.executor_id = executor_id
        StatControllerDomainException.__init__(
            self,
            f"task_id = {task_id}, status = {status.value}, "
            f"executor_id = {current_executor_id} -> {executor_id}",
        )
