from datetime import datetime, timedelta, timezone

from maps_adv.stat_controller.server.lib.data_managers.system_op import (
    SystemOpManager,
    UnexpectedTransactionMode,
)

__all__ = ["Domain", "UnexpectedTransactionMode"]


class Domain:
    __slots__ = "_dm", "task_lifetime"

    _dm: SystemOpManager
    task_lifetime: int

    def __init__(self, dm: SystemOpManager, task_lifetime: int):
        self._dm = dm
        self.task_lifetime = task_lifetime

    async def mark_expired_tasks_as_failed(self):
        now = datetime.now(tz=timezone.utc)
        expired_at = now - timedelta(seconds=self.task_lifetime)

        await self._dm.mark_expired_tasks_as_failed(expired_at)
