import asyncio

from .domains.system_op import Domain


async def auto_mark_expired_tasks(domain: Domain, period: int, loop):
    async def task():
        try:
            await domain.mark_expired_tasks_as_failed()
        except asyncio.CancelledError:
            pass

    async def wait_task():
        await asyncio.wait_for(task(), 60)

    while True:
        loop.create_task(wait_task())
        await asyncio.sleep(period)
