PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    maps_adv/stat_controller/server
)

SRCDIR(maps_adv/stat_controller/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/charger/__init__.py
    api/collector/__init__.py
    api/normalizer/__init__.py
    api_providers/__init__.py
    api_providers/charger/__init__.py
    api_providers/collector/__init__.py
    api_providers/normalizer/__init__.py
    conftest.py
    data_managers/__init__.py
    data_managers/base/__init__.py
    data_managers/charger/__init__.py
    data_managers/collector/__init__.py
    data_managers/normalizer/__init__.py
    data_managers/system_op/__init__.py
    db/__init__.py
    domains/__init__.py
    domains/charger/__init__.py
    domains/collector/__init__.py
    domains/normalizer/__init__.py
    domains/system_op/__init__.py
    tools.py
)

TEST_SRCS(
    api/charger/test_find_new_task.py
    api/charger/test_update_task.py
    api/collector/test_find_new_task.py
    api/collector/test_update_task.py
    api/normalizer/test_find_new_task.py
    api/normalizer/test_update_task.py
    api/test_basic_api_implemetation.py
    api/test_ping.py
    api_providers/charger/test_find_new_task.py
    api_providers/charger/test_update_task.py
    api_providers/collector/test_find_new_task.py
    api_providers/collector/test_update_task.py
    api_providers/normalizer/test_find_new_task.py
    api_providers/normalizer/test_update_task.py
    data_managers/base/test_lock.py
    data_managers/charger/test_find_oldest_available.py
    data_managers/charger/test_is_there_tasks_in_progress.py
    data_managers/charger/test_retrieve_task_details.py
    data_managers/charger/test_update_task.py
    data_managers/collector/test_find_last_available.py
    data_managers/collector/test_reanimate_last_failed_task.py
    data_managers/collector/test_retrieve_task_details.py
    data_managers/collector/test_update_task.py
    data_managers/normalizer/test_create_task.py
    data_managers/normalizer/test_is_there_tasks_in_progress.py
    data_managers/normalizer/test_find_last_task.py
    data_managers/normalizer/test_find_failed_task.py
    data_managers/normalizer/test_retrieve_task_details.py
    data_managers/normalizer/test_update_task.py
    data_managers/system_op/test_mark_expired_tasks_as_failed.py
    data_managers/system_op/test_validate_db_connection.py
    db/test_tasks.py
    db/test_tasks_log.py
    domains/charger/test_find_new_task.py
    domains/charger/test_update_task.py
    domains/collector/test_find_new_task.py
    domains/collector/test_update_task.py
    domains/normalizer/test_find_new_task.py
    domains/normalizer/test_update_task.py
    domains/system_op/test_mark_expired_tasks_as_failed.py
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)


END()
