PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/alembic
    contrib/python/asyncpg
    contrib/python/dateutil
    contrib/python/gunicorn
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2
    contrib/python/psycopg2
    contrib/python/sqlalchemy/sqlalchemy-1.2

    smb/common/multiruntime

    maps_adv/common/helpers
    maps_adv/common/protomallow
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/charger.py
    lib/api/collector.py
    lib/api/middlewares.py
    lib/api/normalizer.py
    lib/api/system_op.py
    lib/api_providers/__init__.py
    lib/api_providers/charger.py
    lib/api_providers/collector.py
    lib/api_providers/normalizer.py
    lib/api_providers/schemas.py
    lib/data_managers/__init__.py
    lib/data_managers/base.py
    lib/data_managers/charger.py
    lib/data_managers/collector.py
    lib/data_managers/normalizer.py
    lib/data_managers/system_op.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/db/enums.py
    lib/db/tables.py
    lib/domains/__init__.py
    lib/domains/charger.py
    lib/domains/collector.py
    lib/domains/exceptions.py
    lib/domains/normalizer.py
    lib/domains/system_op.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/stat_controller/server/
    alembic.ini
    lib/db/migrations/env.py
    lib/db/migrations/script.py.mako
    lib/db/migrations/versions/20190910_1552_7fe4633d1aa2.py
    lib/db/migrations/versions/20190920_1925_34aa0c0ef507.py
    lib/db/migrations/versions/20190924_2042_00d1282a6f9b.py
    lib/db/migrations/versions/20190927_0811_658cbe218c08.py
    lib/db/migrations/versions/20190927_1436_338e7eeadb1c.py
    lib/db/migrations/versions/20191011_1932_c91f0fae1aaf.py
)

END()

RECURSE_FOR_TESTS(tests)
