from datetime import datetime
from typing import List

from maps_adv.stat_tasks_starter.lib.charger.clients import AdvStoreClient

from .filter import filter_to_stop


class CampaignStopper:
    def __init__(self, adv_store_url: str):
        self.adv_store_url = adv_store_url

    async def __call__(self, orders: List[dict], time_moment: datetime):
        campaigns_to_stop = filter_to_stop(orders)
        info_for_adv_store = {
            "processed_at": time_moment,
            "campaigns": campaigns_to_stop,
        }

        async with AdvStoreClient(self.adv_store_url) as adv_store_client:
            await adv_store_client.send_campaigns_to_stop(info_for_adv_store)
