from datetime import datetime
from typing import Dict, List

from maps_adv.stat_tasks_starter.lib.charger.clients.adv_store.schemas import (
    AdvStoreOutputSchema,
    CampaignsToCloseListInputSchema,
)
from maps_adv.stat_tasks_starter.lib.charger.clients.base import BaseClient


class AdvStoreClient(BaseClient):
    async def receive_active_campaigns(self, time_moment: datetime) -> List[dict]:
        params = {"active_at": int(time_moment.timestamp())}
        got = await self._request(
            "GET", "/v2/campaigns/charger/cpm/", 200, params=params
        )
        return AdvStoreOutputSchema().from_bytes(got)["campaigns"]

    async def send_campaigns_to_stop(self, campaigns_to_stop: Dict) -> None:
        data = CampaignsToCloseListInputSchema().to_bytes(
            {
                "processed_at": campaigns_to_stop["processed_at"],
                "campaigns": campaigns_to_stop["campaigns"],
            }
        )
        await self._request("PUT", "/campaigns/charger/stop/", 200, data=data)
