from marshmallow import fields

from maps_adv.adv_store.api.proto import charger_api_pb2
from maps_adv.common.protomallow import (
    PbDateTimeField,
    PbEnumField,
    PbFixedDecimalDictField,
    ProtobufSchema,
)
from maps_adv.stat_tasks_starter.lib.charger.clients.adv_store.enums import (
    ReasonsToStop,
)

enums_map = [
    (
        charger_api_pb2.ReasonStopped.Enum.Value("ORDER_LIMIT_REACHED"),
        ReasonsToStop.order_limit,
    ),
    (
        charger_api_pb2.ReasonStopped.Enum.Value("DAILY_BUDGET_REACHED"),
        ReasonsToStop.daily_budget_limit,
    ),
    (
        charger_api_pb2.ReasonStopped.Enum.Value("BUDGET_REACHED"),
        ReasonsToStop.budget_limit,
    ),
]


class AdvStoreElementOutputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = charger_api_pb2.CampaignForCharger

    campaign_id = fields.Integer()
    order_id = fields.Integer()
    cost = PbFixedDecimalDictField(places=4, field="value")
    budget = PbFixedDecimalDictField(places=4, field="value")
    daily_budget = PbFixedDecimalDictField(places=4, field="value")
    timezone = fields.String()


class AdvStoreOutputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = charger_api_pb2.CampaignForChargerList

    campaigns = fields.Nested(AdvStoreElementOutputSchema, many=True)


class CampaignToCloseInputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = charger_api_pb2.CampaignToStop

    reason_stopped = PbEnumField(
        enum=ReasonsToStop,
        pb_enum=charger_api_pb2.ReasonStopped.Enum,
        values_map=enums_map,
    )
    campaign_id = fields.Integer()


class CampaignsToCloseListInputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = charger_api_pb2.CampaignsToStopList

    processed_at = PbDateTimeField()
    campaigns = fields.Nested(CampaignToCloseInputSchema, many=True)
