from marshmallow import fields

from maps_adv.billing_proxy.proto import orders_charge_pb2, orders_for_stat_pb2
from maps_adv.common.protomallow import PbDateTimeField, PbDecimalField, ProtobufSchema


class OrderListElementSchema(ProtobufSchema):
    class Meta:
        pb_message_class = orders_for_stat_pb2.OrderStatInfo

    order_id = fields.Integer()
    balance = PbDecimalField(places=6)


class ReceiveOrdersInputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = orders_for_stat_pb2.OrdersStatInfoInput

    order_ids = fields.List(fields.Integer())


class ReceiveOrdersOutputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = orders_for_stat_pb2.OrdersStatInfo

    orders_info = fields.Nested(OrderListElementSchema, many=True)


class OrderChargeInputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = orders_charge_pb2.OrderChargeInput

    order_id = fields.Integer()
    charged_amount = PbDecimalField(places=6)


class SubmitOrdersChargesInputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = orders_charge_pb2.OrdersChargeInput

    orders_charge = fields.Nested(OrderChargeInputSchema, many=True)
    bill_for_timestamp = PbDateTimeField()


class OrderChargeOutputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = orders_charge_pb2.OrderChargeOutput

    order_id = fields.Integer()
    success = fields.Boolean()


class SubmitOrdersChargesOutputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = orders_charge_pb2.OrdersChargeOutput

    charge_result = fields.Nested(OrderChargeOutputSchema, many=True)
