from maps_adv.config_loader import Config

_config = {
    "TASKS_TO_START": {
        "default": ["Normalizer", "Charger", "Collector"],
        "converter": lambda data: [el.strip() for el in data.split(",")],
    },
    "STAT_CONTROLLER_URL": {},
    "SSL_CERT_FILE": {"default": None},
    "SENTRY_DSN": {"default": None},
    # task planning settings
    "RELAUNCH_INTERVAL": {"default": 10, "converter": int},
    "TIMEOUT": {"default": 60, "converter": int},
    # settings for retrying requests to server
    "RETRY_MAX_ATTEMPTS": {"default": 10, "converter": int},
    "RETRY_WAIT_MULTIPLIER": {"default": 0.1, "converter": float},
    # settings for db
    "CH_STORAGE_DB": {},
    "CH_STORAGE_HOST": {},
    "CH_STORAGE_PORT": {"converter": int},
    "CH_STORAGE_USER": {"default": "default"},
    "CH_STORAGE_PASSWORD": {"default": ""},  # "" mean no password
    "CH_STORAGE_USE_SSL": {"default": True, "converter": bool},
    # settings for tables in storage
    "CH_STORAGE_SOURCE_TABLE": {},
    "CH_STORAGE_NORMALIZED_TABLE": {},
    "CH_STORAGE_ACCEPTED_TABLE": {},
    "CH_STORAGE_ACCEPTED_GROUPS_TABLE": {},
    # settings for charger
    "BILLING_URL": {},
    "ADV_STORE_URL": {},
    # settings for collector
    "COLLECTOR_MATCHING_LAG": {"default": 14400, "converter": int},
    # settings for warden tasks
    "WARDEN_URL": {},
    # TODO(megadiablo) Костыль для проверки запуска кампаний в новой
    #                  статистике GEOPROD-3872. По этому в текущей их
    #                  необходимо перестать обрабатывать.
    "MONKEY_PATCH_CAMPAIGNS_FOR_BEEKEEPER": {
        "default": [],
        "converter": lambda data: [
            int(item.strip()) for item in data.split(",") if item.strip()
        ],
    },
}

config = Config(_config)
