from datetime import datetime

from maps_adv.stat_tasks_starter.lib.base import BaseClickhousePoint

from .query_builders import build_select_from_source


class DataShifter(BaseClickhousePoint):
    def __init__(self, table_from: str, table_to: str, **kwargs):
        self.database = kwargs["database"]
        self.table_from = table_from
        self.table_to = table_to
        super().__init__(**kwargs)

    async def __call__(self, timing_from: datetime, timing_to: datetime):
        sql = build_select_from_source(
            self.database, self.table_from, self.table_to, timing_from, timing_to
        )
        await self.client.execute(sql)
