import logging
from decimal import Decimal
from typing import List

logger = logging.getLogger(__name__)


def get_campaigns_not_spending_budget(campaigns_data: List[dict]) -> List[int]:
    return list(
        map(
            lambda camp_data: camp_data["campaign_id"],
            filter(is_campaign_not_spending_budget, campaigns_data),
        )
    )


def is_campaign_not_spending_budget(campaign_data: dict) -> bool:

    # if daily budget is unlimited, it has a chance to spend whole budget
    if campaign_data["daily_budget"] == Decimal("Inf"):
        return False

    # number of days left * daily budget < left budget
    return campaign_data["days_left"] * campaign_data["daily_budget"] < (
        campaign_data["budget"] - campaign_data["charged"]
    )
