PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    maps_adv/stat_tasks_starter

    smb/common/multiruntime

    contrib/python/clickhouse-driver
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    contrib/python/requests
)

SRCDIR(maps_adv/stat_tasks_starter)

RESOURCE(
    fixtures/accepted_setup.sql tests/fixtures/accepted_setup.sql
    fixtures/normalized_setup.sql tests/fixtures/normalized_setup.sql
    fixtures/source_setup.sql tests/fixtures/source_setup.sql
)

PY_SRCS(
    __init__.py
    api/__init__.py
    aresponses/__init__.py
    aresponses/main.py
    aresponses/utils.py
    charger/__init__.py
    charger/campaigns_stopper/__init__.py
    charger/clients/__init__.py
    charger/collector/__init__.py
    charger/conftest.py
    charger/events_saver/__init__.py
    charger/pipeline/__init__.py
    clickhouse_conftest.py
    collector/__init__.py
    conftest.py
    normalizer/__init__.py
    normalizer/conftest.py
    normalizer/pipeline/__init__.py
    normalizer/query_builders/__init__.py
    normalizer/shift_data/__init__.py
    tools.py
    not_spending_budget/__init__.py
    not_spending_budget/conftest.py
)

TEST_SRCS(
    api/test_ping.py
    charger/campaigns_stopper/test_campaigns_stopper.py
    charger/campaigns_stopper/test_filter_to_stop.py
    charger/clients/test_adv_store_collector.py
    charger/clients/test_adv_store_send_campaigns_to_stop.py
    charger/clients/test_billing_receive_orders.py
    charger/clients/test_billing_submit_charges.py
    charger/collector/test_build_select_events_stat.py
    charger/collector/test_build_union_events_selects.py
    charger/collector/test_context_collector.py
    charger/collector/test_events_stat_collector.py
    charger/events_saver/test_build_insert_charged_events.py
    charger/events_saver/test_build_select_events.py
    charger/events_saver/test_events_point.py
    charger/events_saver/test_events_saver.py
    charger/events_saver/test_events_point_check_charges.py
    charger/pipeline/test_calculate.py
    charger/pipeline/test_charge_funds.py
    charger/pipeline/test_collect_data.py
    charger/pipeline/test_find_new_task.py
    charger/pipeline/test_full_execution_from_calculation_completed_step.py
    charger/pipeline/test_full_execution_from_context_received_step.py
    charger/pipeline/test_full_execution_from_pipeline_billing_notified_step.py
    charger/pipeline/test_full_execution_from_pipeline_charged_data_sent_step.py
    charger/pipeline/test_full_execution_from_start.py
    charger/pipeline/test_full_execution_from_start_with_negative_charges.py
    charger/pipeline/test_notify_adv_store.py
    charger/pipeline/test_save_charged_events.py
    charger/test_billing_charger.py
    charger/test_calculator.py
    collector/test_collector.py
    collector/test_pipeline.py
    collector/test_task.py
    normalizer/pipeline/test_find_task.py
    normalizer/pipeline/test_full_execution.py
    normalizer/pipeline/test_normalize_data.py
    normalizer/query_builders/test_build_select_from_source.py
    normalizer/shift_data/test_shift_data.py
    normalizer/test_task.py
    not_spending_budget/test_analyzer.py
    not_spending_budget/test_pipeline.py
    not_spending_budget/test_collector.py
    not_spending_budget/test_event_stat_collector.py
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)

END()
