PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aioch
    contrib/python/aiohttp
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2
    contrib/python/sentry-sdk
    contrib/python/sentry-sdk/sentry_sdk/integrations/aiohttp

    smb/common/multiruntime

    maps_adv/adv_store/client
    maps_adv/adv_store/api/proto
    maps_adv/billing_proxy/proto
    maps_adv/common/protomallow
    maps_adv/config_loader
    maps_adv/stat_controller/client
    maps_adv/warden/client
)

PY_SRCS(
    lib/__init__.py
    lib/api.py
    lib/base/__init__.py
    lib/base/clickhouse_point.py
    lib/base/exceptions.py
    lib/base/pipeline.py
    lib/charger/__init__.py
    lib/charger/billing_charger.py
    lib/charger/calculator.py
    lib/charger/campaigns_stopper/__init__.py
    lib/charger/campaigns_stopper/filter.py
    lib/charger/clients/__init__.py
    lib/charger/clients/adv_store/__init__.py
    lib/charger/clients/adv_store/enums.py
    lib/charger/clients/adv_store/schemas.py
    lib/charger/clients/base.py
    lib/charger/clients/billing/__init__.py
    lib/charger/clients/billing/schemas.py
    lib/charger/clients/exceptions.py
    lib/charger/collector/__init__.py
    lib/charger/collector/events_stat.py
    lib/charger/collector/query_builders.py
    lib/charger/events_saver/__init__.py
    lib/charger/events_saver/events_point.py
    lib/charger/events_saver/query_builders.py
    lib/charger/pipeline.py
    lib/collector/__init__.py
    lib/collector/collector.py
    lib/collector/pipeline.py
    lib/config.py
    lib/normalizer/__init__.py
    lib/normalizer/pipeline.py
    lib/normalizer/query_builders.py
    lib/normalizer/shift_data.py
    lib/tasks.py
    lib/not_spending_budget/__init__.py
    lib/not_spending_budget/analyzer.py
    lib/not_spending_budget/task.py
    lib/not_spending_budget/campaign_charged_stat.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(app)
