CREATE TABLE maps_adv_statistics_raw_metrika_log ON CLUSTER '{cluster}'
(
    _timestamp       DateTime,
    _partition       String,
    _offset          UInt64,
    _idx             UInt32,
    ReceiveTimestamp DateTime default now(),
    CampaignID       UInt32,
    EventGroupId     String,
    APIKey           UInt32,
    DeviceID         String,
    AppPlatform      String,
    AppVersionName   String,
    AppBuildNumber   UInt32,
    Latitude         Float64,
    Longitude        Float64,
    EventName        String
)
    ENGINE = ReplicatedMergeTree(
             '/clickhouse/tables/{shard}/maps_adv_statistics_raw_metrika_log_cdc',
             '{replica}'
        )
        PARTITION BY toDate(_timestamp)
        ORDER BY (CampaignID, EventName, ReceiveTimestamp)
        SETTINGS index_granularity = 8192
;
