CREATE TABLE maps_adv_statistics_raw_metrika_log_unparsed ON CLUSTER '{cluster}'
(
    _timestamp   DateTime,
    _partition   String,
    _offset      UInt64,
    _idx         UInt32,
    unparsed_row Nullable(String),
    reason       Nullable(String)
)
    engine = ReplicatedMergeTree(
             '/clickhouse/tables/{shard}/maps_adv_statistics_raw_metrika_log_unparsed_cdc',
             '{replica}'
        )
        PARTITION BY toYYYYMMDD(_timestamp)
        ORDER BY (_timestamp, _partition, _offset, _idx)
        SETTINGS index_granularity = 8192
;
