CREATE MATERIALIZED VIEW processed_event_group_ids ON CLUSTER  '{cluster}'
(
    receive_timestamp DateTime,
    event_group_id String
)
        ENGINE = ReplicatedMergeTree(
                 '/clickhouse/tables/{shard}/processed_event_group_ids',
                 '{replica}'
            )
            PARTITION BY toDate(receive_timestamp)
            ORDER BY (receive_timestamp, event_group_id)
            SETTINGS index_granularity = 8192

AS
SELECT receive_timestamp, event_group_id
FROM stat.processed_events
;
