from abc import ABC, abstractmethod
from enum import Enum, auto, unique
from typing import Optional

from maps_adv.warden.client.lib import TaskContext


class BaseStep(ABC):
    input_schema = None
    output_schema = None

    async def __call__(self, context: TaskContext = None) -> dict:
        metadata = self.input_schema(strict=True).load(context.metadata).data
        data = await self.run(metadata, context)
        return self.output_schema(strict=True).dump(data).data

    @abstractmethod
    async def run(
        self, data: Optional[dict] = None, context: Optional[TaskContext] = None
    ) -> dict:
        raise NotImplementedError


PAID_EVENTS = ["BILLBOARD_SHOW"]


@unique
class FreeEventProcessingMode(Enum):
    ONLY_IF_PAID_PRESENT = auto()
    ALL_EVENTS = auto()


__all__ = ["BaseStep", "PAID_EVENTS"]
