get_campaign_charge_stats = """
-- tag: get_campaign_charge_stats
    SELECT campaign_id, charged_daily, charged_total, events_count
    FROM
    (
        SELECT campaign_id, Count(*) AS events_count
        FROM normalized_events_distributed
        WHERE
            campaign_id IN ({campaigns_ids})
            AND event_name IN ({event_names})
            AND receive_timestamp BETWEEN {packet_start} AND {packet_end}
        GROUP BY campaign_id
    ) FULL JOIN (
        SELECT campaign_id, charged_total, charged_daily
        FROM (
            SELECT campaign_id, sumMerge(charged_sum) AS charged_total
            FROM aggregated_processed_events_by_campaigns_and_days_distributed
            WHERE
                campaign_id IN ({campaigns_ids})
            GROUP BY campaign_id
        ) LEFT JOIN (
            SELECT campaign_id, Sum(cost) AS charged_daily
            FROM processed_events_distributed
            WHERE
                campaign_id IN ({campaigns_ids})
                AND receive_timestamp BETWEEN {local_day_start} AND {local_day_end}
            GROUP BY campaign_id
        ) USING (campaign_id)
    ) USING (campaign_id)
    SETTINGS joined_subquery_requires_alias=0
"""


events_in_processed_exist = """
-- tag: events_in_processed_exist
    SELECT 1
    FROM processed_events_distributed
    WHERE receive_timestamp BETWEEN {packet_start} AND {packet_end}
      AND campaign_id in ({campaigns_ids})
    LIMIT 1
"""

check_packet_is_processed = """
-- tag: check_packet_is_processed
    SELECT 1
    FROM processed_events_distributed
    WHERE event_name = 'TECHNICAL_PROCESSED_TO'
      AND receive_timestamp = {packet_end}
    LIMIT 1
"""

insert_to_processed_from_subq = """
-- tag: insert_to_processed_from_subq
    INSERT INTO processed_events_distributed
        (receive_timestamp, event_name, campaign_id, event_group_id, device_id, application,
         app_platform, app_version_name, app_build_number, user_latitude, user_longitude, place_id,
         cost, timezone, _normalization_metadata, _processing_metadata
        )
    SELECT *, '{processing_metadata}' FROM ({subq})
"""  # noqa: E501

select_paid_from_normalized_for_processed = """
-- tag: select_paid_from_normalized_for_processed
    SELECT receive_timestamp, event_name, campaign_id, event_group_id, device_id, application,
        app_platform, app_version_name, app_build_number, user_latitude, user_longitude, place_id,
        '{cost}', '{timezone}', _normalization_metadata
    FROM normalized_events_distributed
    WHERE receive_timestamp BETWEEN {packet_start} AND {packet_end}
        AND campaign_id = {campaign_id}
        AND event_name IN ({event_names})
    LIMIT {events_count}
    OFFSET {events_offset}
"""  # noqa: E501

select_beekeeper_technical_event_processed_to = """
    SELECT toDateTime({packet_end}, 'UTC') AS receive_timestamp,
           CAST(
               'TECHNICAL_PROCESSED_TO' AS Enum8(
                   'TECHNICAL_PROCESSED_TO' = 9,
                   'BILLBOARD_SHOW' = 1,
                   'BILLBOARD_TAP' = 2,
                   'ACTION_CALL' = 3,
                   'ACTION_MAKE_ROUTE' = 4,
                   'ACTION_SEARCH' = 5,
                   'ACTION_OPEN_SITE' = 6,
                   'ACTION_OPEN_APP' = 7,
                   'ACTION_SAVE_OFFER' = 8
               )
           ) AS event_name,
           0 AS campaign_id,
           '' AS event_group_id,
           '' AS device_id,
           CAST(
               'BEEKEEPER' AS Enum8(
                   'NAVIGATOR' = 1,
                   'MOBILE_MAPS' = 2,
                   'METRO' = 3,
                   'BEEKEEPER' = 4
               )
           ) AS application,
           CAST(
               'LINUX' AS Enum8(
                   'ANDROID' = 1,
                   'IOS' = 2,
                   'LINUX' = 3
               )
           ) AS app_platform,
           'r{build_revision}' AS app_version_name,
           {build_revision} AS app_build_number,
           CAST('0' AS Decimal(12, 9)) AS user_latitude,
           CAST('0' AS Decimal(12, 9)) AS user_longitude,
           NULL AS place_id,
           0.0 AS cost,
           'UTC' AS timezone,
           '{normalization_metadata}' AS _normalization_metadata
"""

free_events_for_campaigns_exist_in_processed = """
-- tag: free_events_for_campaigns_exist_in_processed
    SELECT 1
    FROM processed_events_distributed
    WHERE campaign_id IN ({campaign_ids})
        AND event_name NOT IN ({event_names})
        AND receive_timestamp BETWEEN {packet_start} AND {packet_end}
    LIMIT 1
"""

select_free_from_normalized_for_processed_only_if_paid_present = """
-- tag: select_free_from_normalized_for_processed_only_if_paid_present
    SELECT receive_timestamp, event_name, campaign_id, event_group_id, device_id, application,
        app_platform, app_version_name, app_build_number, user_latitude, user_longitude, place_id,
        0.0, '{timezone}', _normalization_metadata
    FROM normalized_events_distributed
    WHERE receive_timestamp BETWEEN {packet_start} AND {packet_end}
        AND campaign_id IN ({campaigns_ids})
        AND event_name NOT IN ({event_names})
        AND event_group_id IN (
            SELECT event_group_id
            FROM processed_event_group_ids_distributed
            WHERE receive_timestamp BETWEEN {event_group_id_packet_start} AND {event_group_id_packet_end}
        )
    SETTINGS distributed_product_mode='global'
"""  # noqa: E501

select_free_from_normalized_for_processed_all_events = """
-- tag: select_free_from_normalized_for_processed_all_events
    SELECT receive_timestamp, event_name, campaign_id, event_group_id, device_id, application,
        app_platform, app_version_name, app_build_number, user_latitude, user_longitude, place_id,
        0.0, '{timezone}', _normalization_metadata
    FROM normalized_events_distributed
    WHERE receive_timestamp BETWEEN {packet_start} AND {packet_end}
        AND campaign_id IN ({campaigns_ids})
        AND event_name NOT IN ({event_names})
"""  # noqa: E501
