from datetime import timedelta
from decimal import Decimal
from clickhouse_driver.errors import ServerException

import pytest
import asyncio
from aioch import Client

from maps_adv.common.helpers import dt
from maps_adv.statistics.beekeeper.lib.pipelines import create_charger
from maps_adv.statistics.beekeeper.tests.tools import dt_timestamp
from maps_adv.warden.client.lib import TaskContext

pytestmark = [pytest.mark.asyncio]

metadata_context = {
    "packet_end": "2000-02-02T11:59:20+00:00",
    "packet_start": "2000-02-02T11:59:20+00:00",
    "orders": [
        {
            "balance": "2",
            "campaigns": [
                {
                    "campaign_id": 15,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 101,
        },
        {
            "balance": "0.2",
            "campaigns": [
                {
                    "campaign_id": 16,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 102,
        },
        {
            "balance": "0",
            "campaigns": [
                {
                    "campaign_id": 17,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 103,
        },
        {
            "balance": "4",
            "campaigns": [
                {
                    "campaign_id": 18,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 19,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
            ],
            "order_id": 104,
        },
        {
            "balance": "4",
            "campaigns": [
                {
                    "campaign_id": 21,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 105,
        },
        {
            "balance": "4",
            "campaigns": [
                {
                    "campaign_id": 24,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 106,
        },
        {
            "balance": "2",
            "campaigns": [
                {
                    "campaign_id": 115,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 201,
        },
        {
            "balance": "0.2",
            "campaigns": [
                {
                    "campaign_id": 116,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 202,
        },
        {
            "balance": "0",
            "campaigns": [
                {
                    "campaign_id": 117,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 203,
        },
        {
            "balance": "4",
            "campaigns": [
                {
                    "campaign_id": 118,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 119,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 204,
        },
        {
            "balance": "4",
            "campaigns": [
                {
                    "campaign_id": 121,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 205,
        },
        {
            "balance": "4",
            "campaigns": [
                {
                    "campaign_id": 124,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 206,
        },
        {
            "balance": "6",
            "campaigns": [
                {
                    "campaign_id": 125,
                    "budget": "2",
                    "tz_name": "UTC",
                    "daily_budget": "1",
                    "daily_charged": "0",
                    "paid_events_count": 2,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "paid_event_cost": "1",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 126,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 3,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "paid_event_cost": "1",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 207,
        },
        {
            "balance": "Infinity",
            "campaigns": [
                {
                    "campaign_id": 11,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 12,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 22,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 23,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 111,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 112,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 122,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 123,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "paid_event_cost": "0.001",
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": None,
        },
    ],
}
metadata_calculator = {
    "packet_end": "2000-02-02T11:59:20+00:00",
    "packet_start": "2000-02-02T11:59:20+00:00",
    "orders": [
        {
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 15,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 101,
        },
        {
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 16,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 102,
        },
        {
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 17,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 103,
        },
        {
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 18,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 19,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
            ],
            "order_id": 104,
        },
        {
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 21,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 105,
        },
        {
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 24,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 106,
        },
        {
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 115,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 201,
        },
        {
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 116,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 202,
        },
        {
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 117,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 203,
        },
        {
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 118,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 119,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 204,
        },
        {
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 121,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 205,
        },
        {
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 124,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 206,
        },
        {
            "balance": "6",
            "amount_to_bill": "3.500",
            "campaigns": [
                {
                    "campaign_id": 125,
                    "budget": "2",
                    "tz_name": "UTC",
                    "daily_budget": "1",
                    "daily_charged": "0",
                    "paid_events_count": 2,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "1",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 126,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 3,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "0.5",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 3,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 207,
        },
        {
            "balance": "Infinity",
            "amount_to_bill": "0.004",
            "campaigns": [
                {
                    "campaign_id": 11,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 12,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 22,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 23,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 111,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 112,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 122,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 123,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": None,
        },
    ],
}
metadata_billing = {
    "packet_end": "2000-02-02T11:59:20+00:00",
    "packet_start": "2000-02-02T11:59:20+00:00",
    "orders": [
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 15,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 101,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 16,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 102,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 17,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 103,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 18,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 19,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
            ],
            "order_id": 104,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 21,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 105,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 24,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 106,
        },
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 115,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 201,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 116,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 202,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 117,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 203,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 118,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 119,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 204,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 121,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 205,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 124,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 206,
        },
        {
            "billing_success": True,
            "balance": "6",
            "amount_to_bill": "3.500",
            "campaigns": [
                {
                    "campaign_id": 125,
                    "budget": "2",
                    "tz_name": "UTC",
                    "daily_budget": "1",
                    "daily_charged": "0",
                    "paid_events_count": 2,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "1",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 126,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 3,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "0.5",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 3,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 207,
        },
        {
            "billing_success": None,
            "balance": "Infinity",
            "amount_to_bill": "0.004",
            "campaigns": [
                {
                    "campaign_id": 11,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 12,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 22,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 23,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 111,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 112,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 122,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 123,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": None,
        },
    ],
    "billing_applied": False,
}
metadata_paid_events_porter = {
    "packet_end": "2000-02-02T11:59:20+00:00",
    "packet_start": "2000-02-02T11:59:20+00:00",
    "orders": [
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 15,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 101,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 16,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 102,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 17,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 103,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 18,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 19,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
            ],
            "order_id": 104,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 21,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 105,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 24,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 106,
        },
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 115,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 201,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 116,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 202,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 117,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 203,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 118,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 119,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 204,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 121,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 205,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 124,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 206,
        },
        {
            "billing_success": True,
            "balance": "6",
            "amount_to_bill": "3.500",
            "campaigns": [
                {
                    "campaign_id": 125,
                    "budget": "2",
                    "tz_name": "UTC",
                    "daily_budget": "1",
                    "daily_charged": "0",
                    "paid_events_count": 2,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "1",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 126,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 3,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "0.5",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 3,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 207,
        },
        {
            "billing_success": None,
            "balance": "Infinity",
            "amount_to_bill": "0.004",
            "campaigns": [
                {
                    "campaign_id": 11,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 12,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 22,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 23,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 111,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 112,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 122,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 123,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": None,
        },
    ],
    "billing_applied": False,
}
metadata_adv_store = {
    "packet_end": "2000-02-02T11:59:20+00:00",
    "packet_start": "2000-02-02T11:59:20+00:00",
    "orders": [
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 15,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 101,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 16,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 102,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 17,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 103,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 18,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 19,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
            ],
            "order_id": 104,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 21,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 105,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 24,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                }
            ],
            "order_id": 106,
        },
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 115,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 201,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 116,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 202,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 117,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 203,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 118,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 119,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 204,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 121,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 205,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 124,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                }
            ],
            "order_id": 206,
        },
        {
            "billing_success": True,
            "balance": "6",
            "amount_to_bill": "3.500",
            "campaigns": [
                {
                    "campaign_id": 125,
                    "budget": "2",
                    "tz_name": "UTC",
                    "daily_budget": "1",
                    "daily_charged": "0",
                    "paid_events_count": 2,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "1",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 126,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 3,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "0.5",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 3,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": 207,
        },
        {
            "billing_success": None,
            "balance": "Infinity",
            "amount_to_bill": "0.004",
            "campaigns": [
                {
                    "campaign_id": 11,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 12,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 22,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 23,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                    "free_event_processing_mode": "ONLY_IF_PAID_PRESENT",
                },
                {
                    "campaign_id": 111,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 112,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 122,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
                {
                    "campaign_id": 123,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                    "free_event_processing_mode": "ALL_EVENTS",
                },
            ],
            "order_id": None,
        },
    ],
    "stopped_campaigns": {
        126: "BUDGET_REACHED",
    },
    "billing_applied": False,
}
metadata_free_events_porter = {
    "packet_end": "2000-02-02T11:59:20+00:00",
    "packet_start": "2000-02-02T11:59:20+00:00",
    "orders": [
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 15,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                }
            ],
            "order_id": 101,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 16,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                }
            ],
            "order_id": 102,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 17,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                }
            ],
            "order_id": 103,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 18,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                },
                {
                    "campaign_id": 19,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                },
            ],
            "order_id": 104,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 21,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                }
            ],
            "order_id": 105,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 24,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                }
            ],
            "order_id": 106,
        },
        {
            "billing_success": None,
            "balance": "2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 115,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                }
            ],
            "order_id": 201,
        },
        {
            "billing_success": None,
            "balance": "0.2",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 116,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                }
            ],
            "order_id": 202,
        },
        {
            "billing_success": None,
            "balance": "0",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 117,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                }
            ],
            "order_id": 203,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 118,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                },
                {
                    "campaign_id": 119,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                },
            ],
            "order_id": 204,
        },
        {
            "billing_success": None,
            "balance": "4",
            "amount_to_bill": "0.000",
            "campaigns": [
                {
                    "campaign_id": 121,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                }
            ],
            "order_id": 205,
        },
        {
            "billing_success": False,
            "balance": "4",
            "amount_to_bill": "0.001",
            "campaigns": [
                {
                    "campaign_id": 124,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                }
            ],
            "order_id": 206,
        },
        {
            "billing_success": True,
            "balance": "6",
            "amount_to_bill": "3.500",
            "campaigns": [
                {
                    "campaign_id": 125,
                    "budget": "2",
                    "tz_name": "UTC",
                    "daily_budget": "1",
                    "daily_charged": "0",
                    "paid_events_count": 2,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "1",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                },
                {
                    "campaign_id": 126,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 3,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                    "last_paid_event_cost": "0.5",
                    "paid_event_cost": "1",
                    "paid_events_to_charge": 3,
                    "billing_type": "cpa",
                },
            ],
            "order_id": 207,
        },
        {
            "billing_success": None,
            "balance": "Infinity",
            "amount_to_bill": "0.004",
            "campaigns": [
                {
                    "campaign_id": 11,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                },
                {
                    "campaign_id": 12,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpm",
                },
                {
                    "campaign_id": 22,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                },
                {
                    "campaign_id": 23,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": ["BILLBOARD_SHOW"],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpm",
                },
                {
                    "campaign_id": 111,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                },
                {
                    "campaign_id": 112,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 0,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 0,
                    "billing_type": "cpa",
                },
                {
                    "campaign_id": 122,
                    "budget": "Infinity",
                    "tz_name": "UTC",
                    "daily_budget": "2.5",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                },
                {
                    "campaign_id": 123,
                    "budget": "2.5",
                    "tz_name": "UTC",
                    "daily_budget": "Infinity",
                    "daily_charged": "0",
                    "paid_events_count": 1,
                    "charged": "0",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                    "last_paid_event_cost": "0.001",
                    "paid_event_cost": "0.001",
                    "paid_events_to_charge": 1,
                    "billing_type": "cpa",
                },
            ],
            "order_id": None,
        },
    ],
    "stopped_campaigns": {
        126: "BUDGET_REACHED",
    },
    "billing_applied": False,
}

metadata_mark_processed_packet = metadata_free_events_porter


# TODO(megadiablo) GEOPROD-3870, GEOPROD-4108 Убрать опцию после
#                  запуска новой статистики
@pytest.mark.parametrize(
    ["campaigns_for_processing", "additional_campaigns"],
    [
        (None, []),
        (
            [
                11,
                12,
                15,
                16,
                17,
                18,
                19,
                21,
                22,
                23,
                24,
                111,
                112,
                115,
                116,
                117,
                118,
                119,
                121,
                122,
                123,
                124,
                125,
                126,
            ],
            [
                # For filtering by option MONKEY_PATCH_CAMPAIGNS_FOR_BEEKEEPER
                {
                    "campaign_id": 100500,
                    "order_id": None,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                {
                    "campaign_id": 100600,
                    "order_id": 106,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
            ],
        ),
    ],
)  # GEOPROD-4108
@pytest.mark.parametrize(["status", "metadata"], [("accepted", {})])
@pytest.mark.parametrize(
    [
        "normalized_events_distributed",
        "list_active_cpm_campaigns",
        "list_active_cpa_campaigns",
        "fetch_orders_balance",
        "submit_orders_charges",
    ],
    [
        (
            [  # normalized_events_distributed
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:30")),
                    "event_name": "BILLBOARD_SHOW",
                    "campaign_id": 12,
                    "event_group_id": "evgrpid_c12_num_2",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 12:00:10")),
                    "event_name": "BILLBOARD_SHOW",
                    "campaign_id": 12,
                    "event_group_id": "evgrpid_c12_num_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 12:00:14")),
                    "event_name": "BILLBOARD_SHOW",
                    "campaign_id": 13,
                    "event_group_id": "evgrpid_c13_num_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 12:00:16")),
                    "event_name": "BILLBOARD_SHOW",
                    "campaign_id": 13,
                    "event_group_id": "evgrpid_c13_num_2",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "BILLBOARD_SHOW",
                    "campaign_id": 22,
                    "event_group_id": "someeventgroupidinnormalized",
                    "device_id": "c_22_paid_prev_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "BILLBOARD_SHOW",
                    "campaign_id": 23,
                    "event_group_id": "someeventgroupidinnormalized",
                    "device_id": "c_23_paid_prev_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "BILLBOARD_SHOW",
                    "campaign_id": 24,
                    "event_group_id": "someeventgroupidinnormalized",
                    "device_id": "c_24_paid_prev_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:30")),
                    "event_name": "ACTION_CALL",
                    "campaign_id": 112,
                    "event_group_id": "evgrpid_c12_num_2",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 12:00:10")),
                    "event_name": "ACTION_MAKE_ROUTE",
                    "campaign_id": 112,
                    "event_group_id": "evgrpid_c12_num_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 12:00:14")),
                    "event_name": "ACTION_SEARCH",
                    "campaign_id": 113,
                    "event_group_id": "evgrpid_c13_num_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 12:00:16")),
                    "event_name": "ACTION_OPEN_SITE",
                    "campaign_id": 113,
                    "event_group_id": "evgrpid_c13_num_2",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_OPEN_APP",
                    "campaign_id": 122,
                    "event_group_id": "someeventgroupidinnormalized",
                    "device_id": "c_22_paid_prev_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_SAVE_OFFER",
                    "campaign_id": 123,
                    "event_group_id": "someeventgroupidinnormalized",
                    "device_id": "c_23_paid_prev_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_CALL",
                    "campaign_id": 124,
                    "event_group_id": "someeventgroupidinnormalized",
                    "device_id": "c_24_paid_prev_1",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_MAKE_ROUTE",
                    "campaign_id": 125,
                    "event_group_id": "dont_know_what_group_id_is",
                    "device_id": "c_125_paid_0",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_MAKE_ROUTE",
                    "campaign_id": 125,
                    "event_group_id": "dont_know_what_group_id_is",
                    "device_id": "c_125_paid_0",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_MAKE_ROUTE",
                    "campaign_id": 126,
                    "event_group_id": "dont_know_what_group_id_is",
                    "device_id": "c_126_paid_0",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_MAKE_ROUTE",
                    "campaign_id": 126,
                    "event_group_id": "dont_know_what_group_id_is",
                    "device_id": "c_126_paid_0",
                },
                {
                    "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:20")),
                    "event_name": "ACTION_MAKE_ROUTE",
                    "campaign_id": 126,
                    "event_group_id": "dont_know_what_group_id_is",
                    "device_id": "c_126_paid_0",
                },
            ],
            [  # list_active_cpm_campaigns,
                # Just a campaign
                {
                    "campaign_id": 11,
                    "order_id": None,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # Just a campaign with free events
                {
                    "campaign_id": 12,
                    "order_id": None,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # Campaign with limited order
                {
                    "campaign_id": 15,
                    "order_id": 101,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # Campaign with very limited order
                {
                    "campaign_id": 16,
                    "order_id": 102,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # Campaign with empty order
                {
                    "campaign_id": 17,
                    "order_id": 103,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # Following 2 campaigns have same limited order
                {
                    "campaign_id": 18,
                    "order_id": 104,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                {
                    "campaign_id": 19,
                    "order_id": 104,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # There is another campaign in order 105, but it is inactive
                {
                    "campaign_id": 21,
                    "order_id": 105,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # Campaign with limited daily budget
                {
                    "campaign_id": 22,
                    "order_id": None,
                    "cost": Decimal("1"),
                    "budget": None,
                    "daily_budget": Decimal("2.5"),
                    "timezone": "UTC",
                },
                # Campaign with limited budget
                {
                    "campaign_id": 23,
                    "order_id": None,
                    "cost": Decimal("1"),
                    "budget": Decimal("2.5"),
                    "daily_budget": None,
                    "timezone": "UTC",
                },
                # Campaign with processed order
                {
                    "campaign_id": 24,
                    "order_id": 106,
                    "cost": Decimal("1"),
                    "budget": Decimal("2.5"),
                    "daily_budget": None,
                    "timezone": "UTC",
                },
            ],
            [  # list_active_cpa_campaigns,
                # Just a campaign
                {
                    "campaign_id": 111,
                    "order_id": None,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Just a campaign with free events
                {
                    "campaign_id": 112,
                    "order_id": None,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Campaign with limited order
                {
                    "campaign_id": 115,
                    "order_id": 201,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Campaign with very limited order
                {
                    "campaign_id": 116,
                    "order_id": 202,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Campaign with empty order
                {
                    "campaign_id": 117,
                    "order_id": 203,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Following 2 campaigns have same limited order
                {
                    "campaign_id": 118,
                    "order_id": 204,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                {
                    "campaign_id": 119,
                    "order_id": 204,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # There is another campaign in order 105, but it is inactive
                {
                    "campaign_id": 121,
                    "order_id": 205,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Campaign with limited daily budget
                {
                    "campaign_id": 122,
                    "order_id": None,
                    "cost": Decimal("0.001"),
                    "budget": None,
                    "daily_budget": Decimal("2.5"),
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Campaign with limited budget
                {
                    "campaign_id": 123,
                    "order_id": None,
                    "cost": Decimal("0.001"),
                    "budget": Decimal("2.5"),
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                # Campaign with processed order
                {
                    "campaign_id": 124,
                    "order_id": 206,
                    "cost": Decimal("0.001"),
                    "budget": Decimal("2.5"),
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_CALL",
                        "ACTION_MAKE_ROUTE",
                        "ACTION_SEARCH",
                        "ACTION_OPEN_SITE",
                        "ACTION_OPEN_APP",
                        "ACTION_SAVE_OFFER",
                    ],
                },
                {
                    "campaign_id": 125,
                    "order_id": 207,
                    "cost": Decimal("1"),
                    "budget": Decimal("2"),
                    "daily_budget": Decimal("1"),
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                },
                {
                    "campaign_id": 126,
                    "order_id": 207,
                    "cost": Decimal("1"),
                    "budget": Decimal("2.5"),
                    "daily_budget": None,
                    "timezone": "UTC",
                    "paid_events_names": [
                        "ACTION_MAKE_ROUTE",
                    ],
                },
            ],
            {  # billing_proxy.fetch_orders_balance
                101: Decimal("2"),
                102: Decimal("0.2"),
                103: Decimal("0"),
                104: Decimal("4"),
                105: Decimal("4"),
                106: Decimal("4"),
                201: Decimal("2"),
                202: Decimal("0.2"),
                203: Decimal("0"),
                204: Decimal("4"),
                205: Decimal("4"),
                206: Decimal("4"),
                207: Decimal("6"),
            },
            (  # billing_proxy.submit_orders_charges
                False,
                {
                    101: True,
                    102: True,
                    103: True,
                    104: True,
                    105: True,
                    106: False,
                    201: True,
                    202: True,
                    203: True,
                    204: True,
                    205: True,
                    206: False,
                    207: True,
                },
            ),
        )
    ],
)
async def test_expected_work_pipeline(
    campaigns_for_processing,
    additional_campaigns,
    normalized_events_distributed,
    list_active_cpm_campaigns,
    list_active_cpa_campaigns,
    fetch_orders_balance,
    submit_orders_charges,
    status,
    metadata,
    factory,
    ch_config,
    adv_store_client_mock,
    billing_client_mock,
    warden_client_mock,
):
    # make copies to avoid affecting test parameters during processing
    cmp_campaigns = list_active_cpm_campaigns[:]
    cpa_campaigns = list_active_cpa_campaigns[:]

    cmp_campaigns.extend(additional_campaigns)
    factory.insert_into_normalized(normalized_events_distributed)

    adv_store_client_mock.list_active_cpm_campaigns.coro.return_value = cmp_campaigns
    adv_store_client_mock.list_active_cpa_campaigns.coro.return_value = cpa_campaigns

    billing_client_mock.fetch_orders_balance.coro.return_value = fetch_orders_balance
    billing_client_mock.submit_orders_charges.coro.return_value = submit_orders_charges

    charger = create_charger(
        lag_packet_size=timedelta(seconds=10),
        min_packet_size=timedelta(seconds=10),
        max_packet_size=timedelta(seconds=10),
        time_threshold_free_events=timedelta(seconds=10),
        ch_config=ch_config,
        adv_store_client=adv_store_client_mock,
        billing_proxy_client=billing_client_mock,
        campaigns_for_processing=campaigns_for_processing,
        build_revision=132,
        ch_max_memory_usage=10 * 1024 * 1024 * 1024,
    )

    await charger(
        TaskContext(client=warden_client_mock, status=status, metadata=metadata)
    )

    call_list = warden_client_mock.update_status.call_args_list
    assert list(call_list[0]) == [("context",), dict(metadata=metadata_context)]
    assert list(call_list[1]) == [("calculator",), dict(metadata=metadata_calculator)]
    assert list(call_list[2]) == [("billing",), dict(metadata=metadata_billing)]
    assert list(call_list[3]) == [
        ("paid_events_porter",),
        dict(metadata=metadata_paid_events_porter),
    ]
    assert list(call_list[4]) == [("adv_store",), dict(metadata=metadata_adv_store)]
    assert list(call_list[5]) == [
        ("free_events_porter",),
        dict(metadata=metadata_free_events_porter),
    ]
    assert list(call_list[6]) == [
        ("mark_processed_packet",),
        dict(metadata=metadata_mark_processed_packet),
    ]
    assert len(call_list) == 7
    assert factory.get_all_processed(0, 1) == [
        (dt("2000-02-02 11:59:20"), "BILLBOARD_SHOW"),
        (dt("2000-02-02 11:59:20"), "BILLBOARD_SHOW"),
        (dt("2000-02-02 11:59:20"), "ACTION_MAKE_ROUTE"),
        (dt("2000-02-02 11:59:20"), "ACTION_MAKE_ROUTE"),
        (dt("2000-02-02 11:59:20"), "ACTION_MAKE_ROUTE"),
        (dt("2000-02-02 11:59:20"), "ACTION_MAKE_ROUTE"),
        (dt("2000-02-02 11:59:20"), "ACTION_OPEN_APP"),
        (dt("2000-02-02 11:59:20"), "ACTION_SAVE_OFFER"),
        (dt("2000-02-02 11:59:20"), "TECHNICAL_PROCESSED_TO"),
    ]


async def test_processing_packet_without_active_campaigns(
    factory, ch_config, adv_store_client_mock, billing_client_mock, warden_client_mock
):
    adv_store_client_mock.list_active_cpm_campaigns.coro.return_value = []
    adv_store_client_mock.list_active_cpa_campaigns.coro.return_value = []
    billing_client_mock.fetch_orders_balance.coro.return_value = {}
    billing_client_mock.submit_orders_charges.coro.return_value = (False, {})

    factory.insert_into_normalized(
        [
            {
                "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:30")),
                "event_name": "BILLBOARD_SHOW",
                "campaign_id": 1,
                "event_group_id": "evgrpid_c12_num_2",
            }
        ]
    )

    charger = create_charger(
        lag_packet_size=timedelta(seconds=10),
        min_packet_size=timedelta(seconds=10),
        max_packet_size=timedelta(seconds=10),
        time_threshold_free_events=timedelta(seconds=10),
        ch_config=ch_config,
        adv_store_client=adv_store_client_mock,
        billing_proxy_client=billing_client_mock,
        build_revision=132,
        ch_max_memory_usage=10 * 1024 * 1024 * 1024,
    )

    await charger(
        TaskContext(client=warden_client_mock, status="accepted", metadata={})
    )

    call_list = warden_client_mock.update_status.call_args_list
    assert list(call_list[0]) == [
        ("context",),
        dict(
            metadata=dict(
                orders=[],
                packet_end="2000-02-02T11:59:30+00:00",
                packet_start="2000-02-02T11:59:30+00:00",
            )
        ),
    ]
    assert list(call_list[1]) == [
        ("calculator",),
        dict(
            metadata=dict(
                orders=[],
                packet_end="2000-02-02T11:59:30+00:00",
                packet_start="2000-02-02T11:59:30+00:00",
            )
        ),
    ]
    assert list(call_list[2]) == [
        ("billing",),
        dict(
            metadata=dict(
                orders=[],
                packet_end="2000-02-02T11:59:30+00:00",
                packet_start="2000-02-02T11:59:30+00:00",
                billing_applied=False,
            )
        ),
    ]
    assert list(call_list[3]) == [
        ("paid_events_porter",),
        dict(
            metadata=dict(
                orders=[],
                packet_end="2000-02-02T11:59:30+00:00",
                packet_start="2000-02-02T11:59:30+00:00",
                billing_applied=False,
            )
        ),
    ]
    assert list(call_list[4]) == [
        ("adv_store",),
        dict(
            metadata=dict(
                orders=[],
                packet_end="2000-02-02T11:59:30+00:00",
                packet_start="2000-02-02T11:59:30+00:00",
                billing_applied=False,
                stopped_campaigns={},
            )
        ),
    ]
    assert list(call_list[5]) == [
        ("free_events_porter",),
        dict(
            metadata=dict(
                orders=[],
                packet_end="2000-02-02T11:59:30+00:00",
                packet_start="2000-02-02T11:59:30+00:00",
                billing_applied=False,
                stopped_campaigns={},
            )
        ),
    ]
    assert list(call_list[6]) == [
        ("mark_processed_packet",),
        dict(
            metadata=dict(
                orders=[],
                packet_end="2000-02-02T11:59:30+00:00",
                packet_start="2000-02-02T11:59:30+00:00",
                billing_applied=False,
                stopped_campaigns={},
            )
        ),
    ]
    assert len(call_list) == 7
    assert factory.get_all_processed(0, 1) == [
        (dt("2000-02-02 11:59:30"), "TECHNICAL_PROCESSED_TO")
    ]


async def test_fails_if_query_already_in_progress(
    factory,
    config,
    ch_config,
    adv_store_client_mock,
    billing_client_mock,
    warden_client_mock,
):
    adv_store_client_mock.list_active_cpm_campaigns.coro.return_value = []
    adv_store_client_mock.list_active_cpa_campaigns.coro.return_value = []
    billing_client_mock.fetch_orders_balance.coro.return_value = {}
    billing_client_mock.submit_orders_charges.coro.return_value = (False, {})

    factory.insert_into_normalized(
        [
            {
                "receive_timestamp": int(dt_timestamp("2000-02-02 11:59:30")),
                "event_name": "BILLBOARD_SHOW",
                "campaign_id": 1,
                "event_group_id": "evgrpid_c12_num_2",
            }
        ]
    )

    charger = create_charger(
        lag_packet_size=timedelta(seconds=10),
        min_packet_size=timedelta(seconds=10),
        max_packet_size=timedelta(seconds=10),
        time_threshold_free_events=timedelta(seconds=10),
        ch_config=ch_config,
        adv_store_client=adv_store_client_mock,
        billing_proxy_client=billing_client_mock,
        build_revision=132,
        ch_max_memory_usage=10 * 1024 * 1024 * 1024,
        ch_query_id=config["CH_PROCESSOR_QUERY_ID"],
    )

    ch_client = Client(**ch_config)

    task = asyncio.create_task(
        charger(TaskContext(client=warden_client_mock, status="accepted", metadata={}))
    )

    with pytest.raises(ServerException):
        await ch_client.execute(
            "SELECT 1, sleep(3)", query_id=config["CH_PROCESSOR_QUERY_ID"]
        )
        await task
