PY3TEST()

OWNER(g:maps-adv)

CONFTEST_LOAD_POLICY_LOCAL()

PEERDIR(
    contrib/python/clickhouse-driver
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    smb/common/multiruntime

    maps_adv/common/lasagna/pytest
    maps_adv/statistics/beekeeper
)

SRCDIR(maps_adv/statistics/beekeeper)

PY_SRCS(
    __init__.py
    conftest.py
    factory.py
    tools.py
    test_normalization_task/__init__.py
    test_normalization_task/appmetric_only/__init__.py
    test_normalization_task/mapkit_and_appmetric/__init__.py
    test_normalization_task/conftest.py
    api/__init__.py
    pipelines/__init__.py
    steps/conftest.py
    steps/charges_calculator/__init__.py
    steps/context_collector/__init__.py
    steps/free_events_porter/__init__.py
    steps/paid_events_porter/__init__.py
    tasks/__init__.py
)

TEST_SRCS(
    test_packet_size_calculator.py
    api/test_ping.py
    test_normalization_task/appmetric_only/test_base.py
    test_normalization_task/appmetric_only/test_datatube.py
    test_normalization_task/appmetric_only/test_timings.py
    test_normalization_task/mapkit_and_appmetric/test_base.py
    test_normalization_task/mapkit_and_appmetric/test_datatube.py
    test_normalization_task/mapkit_and_appmetric/test_mapkittube.py
    test_normalization_task/mapkit_and_appmetric/test_timings.py
    pipelines/test_charger_pipeline.py
    steps/context_collector/test_data_chared_for_campaigns.py
    steps/context_collector/test_data_daily_charged_for_campaigns.py
    steps/context_collector/test_data_from_clients.py
    steps/context_collector/test_data_packet_size_calculator.py
    steps/context_collector/test_data_paid_events_count.py
    steps/charges_calculator/test_charges_calculator.py
    steps/charges_calculator/test_multicampaign_order.py
    steps/charges_calculator/test_log_warnings.py
    steps/free_events_porter/test_base.py
    steps/free_events_porter/test_multiple_campaigns.py
    steps/paid_events_porter/test_base.py
    steps/paid_events_porter/test_multiple_campaigns.py
    steps/test_adv_store_notification.py
    steps/test_billing_notification.py
    steps/test_mark_processed_packet.py
    tasks/test_events_normalizer.py
    tasks/test_events_normalizer_mapkit.py
    tasks/test_events_processor.py
    tasks/test_paid_till_processor.py
)

RESOURCE(
    fixtures/aggregated_processed_events_by_campaigns_and_days.sql tests/fixtures/aggregated_processed_events_by_campaigns_and_days.sql
    fixtures/maps_adv_statistics_raw_metrika_log.sql tests/fixtures/maps_adv_statistics_raw_metrika_log.sql
    fixtures/mapkit_events.sql tests/fixtures/mapkit_events.sql
    fixtures/normalized_events.sql tests/fixtures/normalized_events.sql
    fixtures/processed_events.sql tests/fixtures/processed_events.sql
    fixtures/processed_event_group_ids.sql tests/fixtures/processed_event_group_ids.sql
)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)

END()
