PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aioch
    contrib/python/aiohttp
    contrib/python/dateutil
    contrib/python/marshmallow/py2

    smb/common/multiruntime

    maps_adv/adv_store/client
    maps_adv/billing_proxy/client
    maps_adv/common/helpers
    maps_adv/common/lasagna
    maps_adv/warden/client
)

PY_SRCS(
    lib/__init__.py
    lib/api.py
    lib/pipelines.py
    lib/paid_till_processor.py
    lib/tasks.py
    lib/normalizer/__init__.py
    lib/normalizer/appmetric_only.py
    lib/normalizer/exceptions.py
    lib/normalizer/mapkit_and_appmetric.py
    lib/normalizer/sqls.py
    lib/packet_size_calculator.py
    lib/steps/__init__.py
    lib/steps/adv_store_notification.py
    lib/steps/base.py
    lib/steps/billing_notification.py
    lib/steps/charges_calculator.py
    lib/steps/context_collector.py
    lib/steps/free_events_porter.py
    lib/steps/mark_processed_packet.py
    lib/steps/paid_events_porter.py
    lib/steps/schemas.py
    lib/steps/sqls.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(app)
