from maps_adv.common.config_loader import ConfigLoader, Option
from maps_adv.common.lasagna import setup_logging
from maps_adv.statistics.dashboard.server.lib import Application

config = ConfigLoader(
    Option("CH_STORAGE_TABLE"),
    Option("CH_STORAGE_AGGREGATED_TABLE"),
    Option("CH_STORAGE_PASSWORD"),
    Option("CH_STAT_DATABASE_URL"),
    Option("CH_SYSTEM_DATABASE_URL"),
    Option("SSL_CERT_FILE", default=None),
    Option("SENTRY_DSN", default=None),
    Option("DATABASE_URL"),
    Option("DATABASE_URL_RO", default=None),
    Option("YQL_TOKEN"),
    Option("YQL_CLUSTER", default="hahn"),
    Option("YT_POOL", default="maps-adv-statistics"),
    Option(
        "YQL_CATEGORY_SEARCH_REPORT_TABLE",
        default="home/geodisplay/analytics/reports/full_icon_report",
    ),
    Option("WARDEN_URL"),
    Option("WARDEN_TASKS", default=None),
    Option("DB_AUTOMIGRATE", default=False),
    Option("ADV_STORE_URL"),
    # TODO(megadiablo) Костыль для отображения новой статистики для
    #                  определенных кампаний запуска кампаний.
    #                  Необходимо избавиться от костыля, когда переедем
    #                  полностью на новую версию статистики GEOPROD-4252
    Option(
        "MONKEY_PATCH_CAMPAIGNS_ONLY_FOR_V2",
        default=[],
        converter=lambda data: [
            int(item.strip()) for item in data.split(",") if item.strip()
        ],
    ),
    Option("MONKEY_PATCH_ALL_CAMPAIGNS_USE_V2", default=False, converter=bool),
    Option("JUGGLER_EVENTS_URL", default="http://localhost:31579"),
    Option("NANNY_SERVICE_ID", default=""),
)


def main():
    setup_logging()
    config.init()

    app = Application(config)
    app.run()


if __name__ == "__main__":
    main()
