import sqlalchemy as sa

_constaints_naming_convention = {
    "ix": "ix_%(column_0_label)s",
    "uq": "uq_%(table_name)s_%(column_0_name)s",
    "ck": "ck_%(table_name)s_%(constraint_name)s",
    "fk": "fk_%(table_name)s_%(column_0_name)s_%(referred_table_name)s",
    "pk": "pk_%(table_name)s",
}

metadata = sa.MetaData(naming_convention=_constaints_naming_convention)

category_search_report = sa.Table(
    "category_search_report",
    metadata,
    sa.Column("id", sa.BigInteger, primary_key=True),
    sa.Column("campaign_id", sa.BigInteger, nullable=False),
    sa.Column("date", sa.Date, nullable=False),
    sa.Column("routes", sa.BigInteger, nullable=False),
    sa.Column("devices", sa.BigInteger, nullable=False),
    sa.Column("pin_clicks", sa.BigInteger, nullable=False),
    sa.Column("pin_shows", sa.BigInteger, nullable=False),
    sa.Column("icon_clicks", sa.BigInteger, nullable=False),
    sa.Column("icon_shows", sa.BigInteger, nullable=False),
    sa.Column("created_at", sa.BigInteger, nullable=False),
    sa.Index("ix_campaign_ids", "campaign_id", "date", unique=True),
)
