from datetime import datetime
from typing import Iterable, Tuple


def calculate_campaign_events(
    events_query: Iterable[Tuple[int, str]], period_from: datetime, period_to: datetime
):
    events_query = ",".join(f"({id}, '{type}')" for id, type in events_query)

    return f"""
        SELECT
            campaign_id,
            count(*) AS events
        FROM processed_events_distributed
        WHERE (campaign_id, event_name) IN ({events_query})
          AND (receive_timestamp BETWEEN {int(period_from.timestamp())}
                                 AND {int(period_to.timestamp())})
        GROUP BY campaign_id
    """
