PY3TEST()

OWNER(g:maps-adv)
NO_DOCTESTS()

PEERDIR(
    contrib/python/clickhouse-driver
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock
    contrib/python/psycopg2

    maps_adv/common/helpers
    maps_adv/common/lasagna/pytest
    maps_adv/common/pgswim
    maps_adv/statistics/dashboard/server
)

SRCDIR(maps_adv/statistics/dashboard/server)

RESOURCE(
    fixtures/accepted_setup.sql tests/fixtures/accepted_setup.sql
    fixtures/db_stat.sql tests/fixtures/db_stat.sql
    fixtures/db_sys.sql tests/fixtures/db_sys.sql
    fixtures/mapkit_events.sql tests/fixtures/mapkit_events.sql
    fixtures/maps_adv_statistics_raw_metrika_log.sql tests/fixtures/maps_adv_statistics_raw_metrika_log.sql
    fixtures/normalized_events.sql tests/fixtures/normalized_events.sql
    fixtures/processed_events.sql tests/fixtures/processed_events.sql
    fixtures/query_log.sql tests/fixtures/query_log.sql
)

PY_SRCS(
    __init__.py
    api/__init__.py
    api_provider/__init__.py
    ch_query_log/__init__.py
    clickhouse_conftest.py
    conftest.py
    data_manager/__init__.py
    domain/__init__.py
    tasks/__init__.py
    factory.py
)

TEST_SRCS(
    api/test_calculate_by_campaigns_and_period.py
    api/test_calculate_campaigns_charged_sum.py
    api/test_calculate_monitoring_data.py
    api/test_calculate_monitoring_data_for_queries.py
    api/test_fetch_search_icons_statistics.py
    api/test_ping.py
    api/test_calculate_campaigns_events_for_period.py
    api_provider/test_calculate_by_campaigns_and_period.py
    api_provider/test_calculate_campaigns_charged_sum.py
    api_provider/test_fetch_search_icons_statistics.py
    api_provider/test_calculate_monitoring_data.py
    api_provider/test_calculate_monitoring_data_for_queries.py
    api_provider/test_calculate_campaigns_events_for_period.py
    ch_query_log/test_retrieve_metrics_for_queries.py
    data_manager/test_calculate_by_campaigns_and_period.py
    data_manager/test_calculate_campaigns_charged_sum.py
    data_manager/test_calculate_campaigns_displays_for_period.py
    data_manager/test_calculate_metrics.py
    data_manager/test_fetch_search_icons_statistics.py
    data_manager/test_get_campaign_ids_for_period.py
    data_manager/test_retrieve_tables_metrics.py
    data_manager/test_split_campaign_ids.py
    data_manager/test_sync_category_search_reports.py
    data_manager/test_get_aggregate_events.py
    domain/test_calculate_monitoring_data.py
    domain/test_check_not_spending_budget.py
    domain/test_check_overdraft.py
    tasks/test_check_not_spending_budget.py
    tasks/test_sync_category_search_reports.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://dashboard:dashboard@localhost:5433/dashboard?master_as_replica=true)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()

END()

