PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aioch
    contrib/python/aiohttp
    contrib/python/alembic
    contrib/python/sqlalchemy/sqlalchemy-1.2  # transition; see https://st.yandex-team.ru/CONTRIB-2042
    contrib/python/asyncpg
    contrib/python/dateutil

    yql/library/python

    smb/common/multiruntime

    maps_adv/common/helpers
    maps_adv/common/lasagna
    maps_adv/common/protomallow
    maps_adv/common/third_party_clients
    maps_adv/adv_store/client
    maps_adv/warden/client

    maps_adv/statistics/dashboard/proto
)

PY_SRCS(
    lib/__init__.py
    lib/api.py
    lib/api_provider.py
    lib/ch_query_log.py
    lib/data_manager.py
    lib/domain.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/db/tables.py
    lib/sqls.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/statistics/dashboard/server/
    alembic.ini
    lib/db/migrations/env.py
    lib/db/migrations/script.py.mako
    lib/db/migrations/versions/20191210_1328_5ed256f782c6.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(app)
