from typing import Optional

from maps_adv.warden.client.lib.client import ClientWithContextManager


class TaskContext:
    __slots__ = "client", "status", "metadata", "params"

    client: ClientWithContextManager
    status: str
    metadata: dict
    params: dict

    def __init__(
        self,
        *,
        client: ClientWithContextManager,
        status: str,
        metadata: Optional[dict] = None,
        params: Optional[dict] = None,
    ):
        self.client = client
        self.status = status
        self.metadata = metadata if metadata is not None else {}
        self.params = params if params is not None else {}
