import argparse

from maps_adv.common.config_loader import ConfigLoader, Option
from maps_adv.common.lasagna import setup_logging
from maps_adv.warden.server.lib import Application

config = ConfigLoader(
    Option("DATABASE_URL"),
    Option("EXTRA_EXECUTION_TIME", default=10, converter=int),
    Option("WARDEN_URL", default="http://localhost:8080"),
    Option(
        "WARDEN_TASKS",
        default=[],
        converter=lambda data: [el.strip() for el in data.split(",")],
    ),
)

arg_parser = argparse.ArgumentParser("Warden")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
