import asyncio
from typing import List

from aiohttp import web
from smb.common.multiruntime.lib.io import setup_filesystem

from maps_adv.common.lasagna import Lasagna

from . import api, tasks
from .data_managers.tasks import DataManager as TasksDataManager
from .db import DB
from .domains.tasks import Domain as TasksDomain

__all__ = ["Application"]

setup_filesystem("maps_adv/warden/server/")


class Application(Lasagna):
    __slots__ = "periodic_tasks", "tasks_domain"

    SWIM_ENGINE_CLS = DB

    TASKS = {"warden__auto_mark_expired_tasks": tasks.auto_mark_expired_tasks}
    TASKS_KWARGS_KEYS = ["tasks_domain"]

    periodic_tasks: List[asyncio.Task]
    tasks_domain: TasksDomain

    async def _setup_layers(self, db: DB) -> web.Application:
        tasks_dm = TasksDataManager(db)
        self.tasks_domain = TasksDomain(tasks_dm, self.config["EXTRA_EXECUTION_TIME"])

        return api.create(db, self.tasks_domain)
