from aiohttp import web

from maps_adv.warden.server.lib.db import DB
from maps_adv.warden.server.lib.domains.tasks import Domain as TasksDomain

from . import ping, tasks
from .middlewares import all_middlewares

__all__ = ["create"]


def create(db: DB, tasks_domain: TasksDomain) -> web.Application:
    ping_resources = ping.Resources(db)
    tasks_resources = tasks.Resources(tasks_domain)

    api = web.Application(middlewares=all_middlewares)
    api.add_routes(
        [
            web.get("/ping", ping_resources.ping),
            web.post("/tasks/", tasks_resources.create_task),
            web.put("/tasks/", tasks_resources.update_task),
        ]
    )

    return api
