from aiohttp.web import Request, Response, json_response

from maps_adv.warden.server.lib.db import DB

__all__ = ["Resources"]


class Resources:
    __slots__ = ("_db",)

    _db: DB

    def __init__(self, db: DB):
        self._db = db

    async def ping(self, req: Request) -> Response:
        await self._db.healthcheck()
        return json_response(status=204)
