PY3TEST()

OWNER(
    g:maps-adv
    g:geosmb
)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    smb/common/pgswim/pytest

    maps_adv/common/helpers
    maps_adv/common/lasagna/pytest
    maps_adv/warden/server
)

SRCDIR(maps_adv/warden/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    conftest.py
    data_managers/__init__.py
    data_managers/tasks/__init__.py
    domains/__init__.py
    domains/tasks/__init__.py
)

TEST_SRCS(
    api/test_create_task.py
    api/test_ping.py
    api/test_update_task.py
    data_managers/tasks/test_create_task.py
    data_managers/tasks/test_find_last_task_of_type.py
    data_managers/tasks/test_is_executor_id_exists.py
    data_managers/tasks/test_lock.py
    data_managers/tasks/test_mark_task_as_failed.py
    data_managers/tasks/test_mark_tasks_as_failed.py
    data_managers/tasks/test_restore_task.py
    data_managers/tasks/test_retrieve_active_task_details.py
    data_managers/tasks/test_retrieve_last_failed_task_details.py
    data_managers/tasks/test_retrieve_task_details.py
    data_managers/tasks/test_retrieve_task_type_details.py
    data_managers/tasks/test_update_task.py
    domains/tasks/test_create_task.py
    domains/tasks/test_mark_tasks_as_failed.py
    domains/tasks/test_update_task.py
)

CONFTEST_LOAD_POLICY_LOCAL()

ENV(DATABASE_URL_FOR_TESTS=postgresql://warden:warden@localhost:5433/warden)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)

END()
