PY3_LIBRARY()

OWNER(
    g:maps-adv
    g:geosmb
)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/asyncpg
    contrib/python/marshmallow/py2
    contrib/python/psycopg2
    contrib/python/croniter

    smb/common/multiruntime

    smb/common/pgswim

    maps_adv/common/lasagna
    maps_adv/warden/common
    maps_adv/warden/proto
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/ping.py
    lib/api/tasks.py
    lib/data_managers/__init__.py
    lib/data_managers/tasks.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/domains/__init__.py
    lib/domains/tasks.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/warden/server/
    lib/db/migrations/001_20210125/downgrade.sql
    lib/db/migrations/001_20210125/upgrade.sql
    lib/db/migrations/002_20210130/downgrade.sql
    lib/db/migrations/002_20210130/upgrade.sql
    lib/db/migrations/003_20210226/downgrade.sql
    lib/db/migrations/003_20210226/upgrade.sql
    lib/db/migrations/004_20210303/downgrade.sql
    lib/db/migrations/004_20210303/upgrade.sql
    lib/db/migrations/005_20210303/downgrade.sql
    lib/db/migrations/005_20210303/upgrade.sql
    lib/db/migrations/006_20210304/downgrade.sql
    lib/db/migrations/006_20210304/upgrade.sql
    lib/db/migrations/007_20210309/downgrade.sql
    lib/db/migrations/007_20210309/upgrade.sql
    lib/db/migrations/008_20210312/downgrade.sql
    lib/db/migrations/008_20210312/upgrade.sql
    lib/db/migrations/009_20210316/downgrade.sql
    lib/db/migrations/009_20210316/upgrade.sql
    lib/db/migrations/010_20210317/downgrade.sql
    lib/db/migrations/010_20210317/upgrade.sql
    lib/db/migrations/011_20210406/downgrade.sql
    lib/db/migrations/011_20210406/upgrade.sql
    lib/db/migrations/012_20210707/downgrade.sql
    lib/db/migrations/012_20210707/upgrade.sql
    lib/db/migrations/013_20210721/downgrade.sql
    lib/db/migrations/013_20210721/upgrade.sql
    lib/db/migrations/014_20210903/downgrade.sql
    lib/db/migrations/014_20210903/upgrade.sql
    lib/db/migrations/015_20211022/downgrade.sql
    lib/db/migrations/015_20211022/upgrade.sql
    lib/db/migrations/016_20211119/downgrade.sql
    lib/db/migrations/016_20211119/upgrade.sql
    lib/db/migrations/017_20211202/downgrade.sql
    lib/db/migrations/017_20211202/upgrade.sql
    lib/db/migrations/018_20220111/downgrade.sql
    lib/db/migrations/018_20220111/upgrade.sql
    lib/db/migrations/019_20220321/downgrade.sql
    lib/db/migrations/019_20220321/upgrade.sql
    lib/db/migrations/020_20220414/downgrade.sql
    lib/db/migrations/020_20220414/upgrade.sql
    lib/db/migrations/021_20220520/downgrade.sql
    lib/db/migrations/021_20220520/upgrade.sql
    lib/db/migrations/022_20220607/downgrade.sql
    lib/db/migrations/022_20220607/upgrade.sql
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
