#!/bin/bash

set -e

# Скрипт для генерации моделей core-model

JDK_VERSION=11

ARCADIA_ROOT="${PWD}"
while [[ ! -e "${ARCADIA_ROOT}/.arcadia.root" ]]; do
    if [[ "${ARCADIA_ROOT}" == "/" ]]; then
        echo "$0: must be run from inside Arcadia checkout" >&2
        exit 1
    fi
    ARCADIA_ROOT="$(dirname "${ARCADIA_ROOT}")"
done

if [ -e $ARCADIA_ROOT/.hg ]; then
    vcs="hg"
    vcs_tool="$ARCADIA_ROOT/ya tool hg"
elif [ -e $ARCADIA_ROOT/.svn ]; then
    vcs="svn"
    vcs_tool="$ARCADIA_ROOT/ya tool svn"
elif [ -e $ARCADIA_ROOT/.arc ]; then
    vcs="arc"
    vcs_tool="$ARCADIA_ROOT/ya tool arc"
else
    echo "ARCADIA ROOT: $ARCADIA_ROOT is not under hg, svn or arc vcs"
    exit 1
fi

TMP=`mktemp -d`

model_conf="src/main/model-conf"
generated="src/generated/java"

core_model="partner/java/libs/core-model"
model_generator="direct/libs/model-generator"

function doit() {
    dir=$1
    echo "generating $dir..."
    $ARCADIA_ROOT/ya tool java${JDK_VERSION} \
        -classpath "$outdir/*:" \
        ru.yandex.direct.model.generator.Tool \
        "$ARCADIA_ROOT/$dir/$model_conf" -o "$outdir/gen"
    rm -rf "$ARCADIA_ROOT/$dir/$generated"
    mv "$outdir/gen" "$ARCADIA_ROOT/$dir/$generated"
}

function compileit() {
    dir=$1
    echo "building $dir"
    $ARCADIA_ROOT/ya make -DJDK_VERSION=${JDK_VERSION} -q -o "$outdir" "$ARCADIA_ROOT/"$dir
    mv -f "$outdir/"$dir/*.jar "$outdir"
}

echo "building model-generator..."
outdir="$TMP/out"
mkdir "$outdir"
mkdir "$outdir/gen"
$ARCADIA_ROOT/ya make -DJDK_VERSION=${JDK_VERSION} "$ARCADIA_ROOT/$model_generator" -q -o "$outdir"
mv "$outdir/$model_generator/"*/*.jar "$outdir"

doit $core_model
compileit $core_model

echo "update file status in $vcs..."
if [ "$vcs" = "hg" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool st $core_model/$generated >$TMP/status
        cat $TMP/status | awk '/^\?/ {print $2}' > $TMP/added
        cat $TMP/status | awk '/^!/ {print $2}' > $TMP/deleted
        test -s $TMP/added && cat $TMP/added | xargs $vcs_tool add
        test -s $TMP/deleted && cat $TMP/deleted | xargs $vcs_tool remove
        )
elif [ "$vcs" = "svn" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool st $core_model/$generated >$TMP/status
        cat $TMP/status | awk '/^\?/ {print $2}' > $TMP/added
        cat $TMP/status | awk '/^!/ {print $2}' > $TMP/deleted
        test -s $TMP/added && cat $TMP/added | xargs $vcs_tool add
        test -s $TMP/deleted && cat $TMP/deleted | xargs $vcs_tool remove
        )
elif [ "$vcs" = "arc" ]; then
    ( cd "$ARCADIA_ROOT";
        $vcs_tool st -s $core_model/$generated >$TMP/status
        cat $TMP/status | awk '/^\?\?/ {print $2}' > $TMP/added
        cat $TMP/status | awk '/^ [MD]/ {print $2}' > $TMP/modified
        test -s $TMP/added && cat $TMP/added | xargs $vcs_tool add
        test -s $TMP/modified && cat $TMP/modified | xargs $vcs_tool add
        )
else
    echo "wrong vcs"
    exit 1
fi

rm -rf "$TMP"
